import pickle
import numpy as np
import pandas as pd

def compare_sets(ai_output, reference_output):  
    # Compare trend results  
    if len(ai_output) != len(reference_output):
        return False
    
    reference_output = list(reference_output)  
    for elem in ai_output:
        found = False
        for j, other_elem in enumerate(reference_output):
            if np.isclose(elem, other_elem):
                found = True
                del reference_output[j] 
                break
        if not found:
            return False  
    
    return True
    
# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
try:
    with open("pred_result/result.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = None

with open("ref_result/result.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

# Call the satisfies_user_requirements function with both outputs
try:
    result = compare_sets(machine_result, reference_result)
except:
    result = False

print(result)